# Just Voice(JV) Web SDK Example

* An example of using Just Voice(JV) Web SDK built with WebAssembly. 
* Example contains a way to apply JV in multiple streaming services(Progress Download(Video, Audio)).


## Component
| File                    | Description                                                     |
|-------------------------|-----------------------------------------------------------------|
| example.html            | UI to control both JV features and media player.                |
| example.js              | Example code to apply JV features onto a media element.         |
| just_voice.esm.js       | JV Web SDK Library file for ESM.                                |
| just_voice.umd.js       | JV Web SDK Library file for UMD.                                |
| jv_wasm.js              | JV WebAssembly Library file used by 'just_voice.js'             |


## How To Run for Local Access (localhost)

> **Note:**  
> `AudioWorklet` is available only in secure contexts (HTTPS).

1. Load `example.html` using local server.
    - ex1) `cd ${PATH_TO_EXAMPLE_HTML} && python3 -m http.server 8080`
    - ex2) `brew install http-server && cd ${PATH_TO_EXAMPLE_HTML} && http-server -p 8080 .`
2. Open `http://localhost:8080/example.html` in your browser.
3. Enter in "Sources".
   - This is optional. If you don't enter in URL, the default audio source will be used.
   - "URL" is the media URL.
   - Ignore entered URL when "Audio Mic Input".
4. Select "Streaming Type".
   - This will load the media using the selected streaming type.
   - "Video Progressive Download" uses progressive-download to load the video.
   - "Audio Progressive Download" uses progressive-download to load the audio only.
   - "Audio Mic Input" uses the microphone input stream as audio.
5. Use "Playback Control".
   - This controls the media playback. Whether to play, pause, autoplay, etc.
   - "autoplay" can be checked to autoplay the media after "Streaming Type" is selected.
6. Set JV features.
   - Details on JV features can be found in the separate documentation (Please contact GaudioLab.)
